/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.server.ServerMgr;
import com.sun.xml.internal.ws.transport.http.server.WSHttpHandler;
import java.util.concurrent.Executor;
import javax.xml.ws.EndpointReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpEndpoint
extends com.sun.xml.internal.ws.api.server.HttpEndpoint {
    private String address;
    private HttpContext httpContext;
    private final HttpAdapter adapter;
    private final Executor executor;

    public HttpEndpoint(WSEndpoint wSEndpoint, Executor executor) {
        this.executor = executor;
        this.adapter = HttpAdapter.createAlone(wSEndpoint);
    }

    @Override
    public void publish(String string) {
        this.address = string;
        this.httpContext = ServerMgr.getInstance().createContext(string);
        this.publish(this.httpContext);
    }

    public void publish(Object object) {
        if (!(object instanceof HttpContext)) {
            throw new ServerRtException("not.HttpContext.type", object.getClass());
        }
        this.httpContext = (HttpContext)object;
        this.publish(this.httpContext);
    }

    private String getEPRAddress() {
        if (this.address == null) {
            return this.httpContext.getServer().getAddress().toString();
        }
        return this.address;
    }

    @Override
    public void stop() {
        if (this.address == null) {
            this.httpContext.getServer().removeContext(this.httpContext);
        } else {
            ServerMgr.getInstance().removeContext(this.httpContext);
        }
        this.adapter.getEndpoint().dispose();
    }

    private void publish(HttpContext httpContext) {
        httpContext.setHandler(new WSHttpHandler(this.adapter, this.executor));
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... elementArray) {
        WSEndpointImpl wSEndpointImpl = (WSEndpointImpl)this.adapter.getEndpoint();
        String string = this.getEPRAddress();
        return (T)((EndpointReference)clazz.cast(wSEndpointImpl.getEndpointReference(clazz, string, string + "?wsdl", elementArray)));
    }
}

