/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import java.util.LinkedList;
import java.util.List;
import org.wltea.analyzer.core.AnalyzeContext;
import org.wltea.analyzer.core.ISegmenter;
import org.wltea.analyzer.core.Lexeme;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.dic.Hit;

class CJKSegmenter
implements ISegmenter {
    static final String SEGMENTER_NAME = "CJK_SEGMENTER";
    private List<Hit> tmpHits = new LinkedList<Hit>();

    CJKSegmenter() {
    }

    public void analyze(AnalyzeContext context) {
        if (context.getCurrentCharType() != 0) {
            Hit singleCharHit;
            if (!this.tmpHits.isEmpty()) {
                Hit[] tmpArray;
                Hit[] hitArray = tmpArray = this.tmpHits.toArray(new Hit[this.tmpHits.size()]);
                int n = tmpArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Hit hit = hitArray[n2];
                    hit = Dictionary.getSingleton().matchWithHit(context.getSegmentBuff(), context.getCursor(), hit);
                    if (hit.isMatch()) {
                        Lexeme newLexeme = new Lexeme(context.getBufferOffset(), hit.getBegin(), context.getCursor() - hit.getBegin() + 1, 4);
                        context.addLexeme(newLexeme);
                        if (!hit.isPrefix()) {
                            this.tmpHits.remove(hit);
                        }
                    } else if (hit.isUnmatch()) {
                        this.tmpHits.remove(hit);
                    }
                    ++n2;
                }
            }
            if ((singleCharHit = Dictionary.getSingleton().matchInMainDict(context.getSegmentBuff(), context.getCursor(), 1)).isMatch()) {
                Lexeme newLexeme = new Lexeme(context.getBufferOffset(), context.getCursor(), 1, 4);
                context.addLexeme(newLexeme);
                if (singleCharHit.isPrefix()) {
                    this.tmpHits.add(singleCharHit);
                }
            } else if (singleCharHit.isPrefix()) {
                this.tmpHits.add(singleCharHit);
            }
        } else {
            this.tmpHits.clear();
        }
        if (context.isBufferConsumed()) {
            this.tmpHits.clear();
        }
        if (this.tmpHits.size() == 0) {
            context.unlockBuffer(SEGMENTER_NAME);
        } else {
            context.lockBuffer(SEGMENTER_NAME);
        }
    }

    public void reset() {
        this.tmpHits.clear();
    }
}

