/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.UntrustedChecker;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;
import sun.security.x509.NetscapeCertTypeExtension;
import sun.security.x509.X509CertImpl;

public final class SimpleValidator
extends Validator {
    static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    static final String OID_KEY_USAGE = "2.5.29.15";
    static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    static final ObjectIdentifier OBJID_NETSCAPE_CERT_TYPE = NetscapeCertTypeExtension.NetscapeCertType_Id;
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_CODE_SIGNING_CA = "object_signing_ca";
    private Map<X500Principal, List<X509Certificate>> trustedX500Principals;
    private Collection trustedCerts;

    SimpleValidator(String string, Collection collection) {
        super("Simple", string);
        this.trustedCerts = collection;
        this.trustedX500Principals = new HashMap<X500Principal, List<X509Certificate>>();
        for (X509Certificate x509Certificate : collection) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            List<X509Certificate> list = this.trustedX500Principals.get(x500Principal);
            if (list == null) {
                list = new ArrayList<X509Certificate>(2);
                this.trustedX500Principals.put(x500Principal, list);
            }
            list.add(x509Certificate);
        }
    }

    public Collection getTrustedCertificates() {
        return this.trustedCerts;
    }

    X509Certificate[] engineValidate(X509Certificate[] x509CertificateArray, Collection collection, Object object) throws CertificateException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertificateException("null or zero-length certificate chain");
        }
        x509CertificateArray = this.buildTrustedChain(x509CertificateArray);
        Date date = this.validationDate;
        if (date == null) {
            date = new Date();
        }
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        int n = x509CertificateArray.length - 1;
        for (int i = x509CertificateArray.length - 2; i >= 0; --i) {
            X509Certificate x509Certificate = x509CertificateArray[i + 1];
            X509Certificate x509Certificate2 = x509CertificateArray[i];
            try {
                untrustedChecker.check(x509Certificate2, Collections.<String>emptySet());
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new ValidatorException("Untrusted certificate: " + x509Certificate2.getSubjectX500Principal(), ValidatorException.T_UNTRUSTED_CERT, x509Certificate2, certPathValidatorException);
            }
            try {
                AlgorithmChecker.check(x509Certificate2);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new ValidatorException(ValidatorException.T_ALGORITHM_DISABLED, x509Certificate2, certPathValidatorException);
            }
            if (!this.variant.equals("code signing") && !this.variant.equals("jce signing")) {
                x509Certificate2.checkValidity(date);
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) {
                throw new ValidatorException(ValidatorException.T_NAME_CHAINING, x509Certificate2);
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ValidatorException(ValidatorException.T_SIGNATURE_ERROR, x509Certificate2, generalSecurityException);
            }
            if (i == 0) continue;
            n = this.checkExtensions(x509Certificate2, n);
        }
        return x509CertificateArray;
    }

    private int checkExtensions(X509Certificate x509Certificate, int n) throws CertificateException {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        int n2 = this.checkBasicConstraints(x509Certificate, set, n);
        this.checkKeyUsage(x509Certificate, set);
        this.checkNetscapeCertType(x509Certificate, set);
        if (!set.isEmpty()) {
            throw new ValidatorException("Certificate contains unknown critical extensions: " + set, ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
        return n2;
    }

    private void checkNetscapeCertType(X509Certificate x509Certificate, Set set) throws CertificateException {
        if (!this.variant.equals("generic")) {
            if (this.variant.equals("tls client") || this.variant.equals("tls server")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for SSL CA certificate", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
                }
                set.remove(OID_NETSCAPE_CERT_TYPE);
            } else if (this.variant.equals("code signing") || this.variant.equals("jce signing")) {
                if (!SimpleValidator.getNetscapeCertTypeBit(x509Certificate, NSCT_CODE_SIGNING_CA)) {
                    throw new ValidatorException("Invalid Netscape CertType extension for code signing CA certificate", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
                }
                set.remove(OID_NETSCAPE_CERT_TYPE);
            } else {
                throw new CertificateException("Unknown variant " + this.variant);
            }
        }
    }

    static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) {
        try {
            NetscapeCertTypeExtension netscapeCertTypeExtension;
            Object object;
            if (x509Certificate instanceof X509CertImpl) {
                object = (X509CertImpl)x509Certificate;
                ObjectIdentifier objectIdentifier = OBJID_NETSCAPE_CERT_TYPE;
                netscapeCertTypeExtension = (NetscapeCertTypeExtension)((X509CertImpl)object).getExtension(objectIdentifier);
                if (netscapeCertTypeExtension == null) {
                    return true;
                }
            } else {
                object = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
                if (object == null) {
                    return true;
                }
                DerInputStream derInputStream = new DerInputStream((byte[])object);
                byte[] byArray = derInputStream.getOctetString();
                byArray = new DerValue(byArray).getUnalignedBitString().toByteArray();
                netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray);
            }
            object = (Boolean)netscapeCertTypeExtension.get(string);
            return (Boolean)object;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private int checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException {
        set.remove(OID_BASIC_CONSTRAINTS);
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            throw new ValidatorException("End user tried to act as a CA", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
        if (!X509CertImpl.isSelfIssued(x509Certificate)) {
            if (n <= 1) {
                throw new ValidatorException("Violated path length constraints", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
            }
            --n;
        }
        if (n > n2) {
            n = n2;
        }
        return n;
    }

    private void checkKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException {
        set.remove(OID_KEY_USAGE);
        set.remove(OID_EXTENDED_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new ValidatorException("Wrong key usage: expected keyCertSign", ValidatorException.T_CA_EXTENSIONS, x509Certificate);
        }
    }

    private X509Certificate[] buildTrustedChain(X509Certificate[] x509CertificateArray) throws CertificateException {
        Serializable serializable;
        Serializable serializable2;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(x509CertificateArray.length);
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            serializable2 = x509CertificateArray[i];
            serializable = this.getTrustedCertificate((X509Certificate)serializable2);
            if (serializable != null) {
                arrayList.add((X509Certificate)serializable);
                return arrayList.toArray(CHAIN0);
            }
            arrayList.add((X509Certificate)serializable2);
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        serializable2 = x509Certificate.getSubjectX500Principal();
        serializable = x509Certificate.getIssuerX500Principal();
        List<X509Certificate> list = this.trustedX500Principals.get(serializable);
        if (list != null) {
            X509Certificate x509Certificate2 = list.iterator().next();
            arrayList.add(x509Certificate2);
            return arrayList.toArray(CHAIN0);
        }
        throw new ValidatorException(ValidatorException.T_NO_TRUST_ANCHOR);
    }

    private X509Certificate getTrustedCertificate(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        List<X509Certificate> list = this.trustedX500Principals.get(x500Principal);
        if (list == null) {
            return null;
        }
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        PublicKey publicKey = x509Certificate.getPublicKey();
        for (X509Certificate x509Certificate2 : list) {
            if (x509Certificate2.equals(x509Certificate)) {
                return x509Certificate;
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            return x509Certificate2;
        }
        return null;
    }
}

